import sys
import json
import logging
import logging.config
from utils.CSMEParserArgumentParser import CSMEParserArgumentParser
from version import __version__
from cse_image_items.Image import ImageFactory


logger = logging.getLogger(__name__)


def logger_configuration():
    try:
        with open("config/logger_configuration.json", 'r') as logging_configuration_file:
            config_dict = json.load(logging_configuration_file)
    except Exception:
        print('Exception occurred while reading logger_configuration JSON file')
    logging.config.dictConfig(config_dict)


def parse_args(args=None):
    """ Arguments parsing

    Returns:
        argparse.Namespace -- the arguments
     """
    logger.info('START parse_args FUNCTION')

    parser = CSMEParserArgumentParser()
    parser.add_argument('--image', '-img', required=True, help="binary image path")
    parser.add_argument('--layout', '-l', required=True, help="The layout of the image (1.6/1.7)")
    parser.add_argument('--CSERegionOnly', '-cse', required=False,
                        action='store_true', help="defines the input image as a CSE Image type")
    try:
        args = parser.parse_args(args)
        logger.debug('user\'s command is: [%s]' % (args))
        return args
    except SystemExit as exc:
        exit(exc.code)


def main():
    print('Intel(R) CSME RunTime Verification %s version' % (__version__))
    if sys.version_info[:2] < (2, 7):
        logger.error('Python version 2.7 or greater is necessary to run')
        exit(1)
    logger_configuration()
    args = parse_args()
    logger.info('the LAYOUT PARSING has been STARTED... version: %s' % (__version__))
    image = ImageFactory.create(args.image, args.layout, args.CSERegionOnly)
    logger.info('the layout parsing COMPLETED')


if __name__ == '__main__':
    try:
        main()
    except Exception:
        logger.error('unexpected error occurred during image parsing')
        exit(1)
